package arithmeticOperationsUsingBlocks
  /* Arithmetic Operations using Blocks */

  block Sum "Block to sum input signals"
    extends Modelica.Blocks.Interfaces.MISO;
  equation
    y = sum(u);
  end Sum;

  block Product "Block to multiply input signals"
    extends Modelica.Blocks.Interfaces.MISO;
  equation
    y = product(u);
  end Product;

  class main
    /* Using the 'sum' and 'product' blocks on two time varying signals */
    Sum mySum(nin = 2) "Number of input signals is 2";
    Product myProduct(nin = 2) "Number of input signals is 2";
  equation
    mySum.u = {time, 2 * (time^2)};
    myProduct.u = {time, 5};
  end main;
end arithmeticOperationsUsingBlocks;